# -*- coding: utf-8 -*-

__version__ = '$Revision$'
__author__ = 'Atzm WATANABE <sitosito@p.chan.ne.jp>'

import os, ConfigParser

_userconfig = 'amazonbot.ini'
_parser = ConfigParser.SafeConfigParser()

def set(sect, key, val):
	try:
		_parser.set(sect, key, str(val))
	except ConfigParser.NoSectionError:
		_parser.add_section(sect)
		set(sect, key, val)

def get(sect, key, valuetype=''): # valuetype in ['', 'int', 'float', 'boolean']
	try:
		method = getattr(_parser, 'get%s' % valuetype)
		return method(sect, key)
	except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
		if valuetype == 'int':
			return 0
		elif valuetype == 'float':
			return 0.0
		elif valuetype == 'boolean':
			return False
		else:
			return ''

def write(filename=''):
	if not filename:
		filename = _userconfig
	_parser.write(file(filename, 'w'))

def read(filename=''):
	if not filename or not os.path.isfile(filename):
		filename = _userconfig
	_parser.read(filename)

def items(sect='DEFAULT'):
	for key, val in _parser.items(str(sect)):
		yield key, val

def init():
	read()

if __name__ == '__main__':
	import sys
	init()
	_parser.write(sys.stdout)
