/*
 * ksyslog: In-kernel syslog receiver 
 * Copyright(C) 2013 Atzm WATANABE All rights reserved
 * Distributed under the GPL
 */

#ifndef KSYSLOG_COMPAT_H
#define KSYSLOG_COMPAT_H

#ifndef __list_for_each_rcu
#define __list_for_each_rcu(pos, head) \
	for (pos = rcu_dereference_raw(list_next_rcu(head)); \
		pos != (head); \
		pos = rcu_dereference_raw(list_next_rcu(pos)))
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(3,5,0)
static inline void udp_encap_enable(void)
{
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(3,10,0)
#ifdef CONFIG_PROC_FS
static inline void *
PDE_DATA(const struct inode *inode)
{
	return PDE(inode)->data;
}
#endif
#endif

#endif
