/*
 * ksyslog: In-kernel syslog receiver 
 * Copyright(C) 2013 Atzm WATANABE All rights reserved
 * Distributed under the GPL
 */

#ifndef KSYSLOG_COMPAT_H
#define KSYSLOG_COMPAT_H

#ifndef __list_for_each_rcu
#define __list_for_each_rcu(pos, head) \
	for (pos = rcu_dereference_raw(list_next_rcu(head)); \
		pos != (head); \
		pos = rcu_dereference_raw(list_next_rcu(pos)))
#endif

#ifndef list_first_or_null_rcu
#define list_first_or_null_rcu(ptr, type, member) \
({ \
	struct list_head *__ptr = (ptr); \
	struct list_head *__next = ACCESS_ONCE(__ptr->next); \
	likely(__ptr != __next) ? list_entry_rcu(__next, type, member) : NULL; \
 })
#endif

static inline void
compat_fsnotify_open(struct file *file)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,35)
	fsnotify_open(file->f_path.dentry);
#else
	fsnotify_open(file);
#endif
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(3,5,0)
static inline void
udp_encap_enable(void)
{
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(3,10,0)
#ifdef CONFIG_PROC_FS
static inline void *
PDE_DATA(const struct inode *inode)
{
	return PDE(inode)->data;
}
#endif
#endif

#endif
