# -*- coding: utf-8 -*-
# $Id$

import os


_COLOR_ENABLE = True


def set_color_enable(flag):
    global _COLOR_ENABLE
    _COLOR_ENABLE = flag


def _color(str_, color):
    global _COLOR_ENABLE
    list_ = [str(str_)]
    if _COLOR_ENABLE:
        list_.insert(0, color)
        list_.append('\033[0m')
    return ''.join(list_)


def red(str_):
    return _color(str_, '\033[1;31m')


def green(str_):
    return _color(str_, '\033[1;32m')


def yellow(str_):
    return _color(str_, '\033[1;33m')


def cyan(str_):
    return _color(str_, '\033[1;36m')


def isupper_one(str_):
    return len([c for c in str_ if c.isupper()]) > 0


def path2name(path):
    name = os.path.splitext(os.path.basename(path))[0]
    if name.find('_') < 0 and isupper_one(name):
        return name
    return ''.join([p.capitalize() for p in name.split('_')])
