#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Copyright (C) 2010 by Atzm WATANABE <atzm@atzm.org>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id$
#

import sys
import pycodebattler


def _main_entry():
    if len(sys.argv) == 1:
        p = [pycodebattler.warrior.Warrior.make('stdin', sys.stdin)]
    else:
        p = [pycodebattler.warrior.Warrior.make(
             pycodebattler.util.path2name(f), open(f))
             for f in sys.argv[1:]]

    print(pycodebattler.warrior.pformat(p))


if __name__ == '__main__':
    _main_entry()
