/* -*- coding: utf-8 -*-
 *
 * Copyright (C) 2010 by Atzm WATANABE <atzm@atzm.org>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License (version 2) as
 *  published by the Free Software Foundation.  It is distributed in the
 *  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 * $Id$
 *
 */

function touch(x1, y1, s1, x2, y2, s2) {
    var dx = Math.pow(x2 - x1, 2);
    var dy = Math.pow(y2 - y1, 2);
    if (Math.sqrt(dx + dy) < s1 + s2)
        return true;
    return false;
}

var Bomb = function(x, y, w, h, size, speed, colors) {
    this.x      = x;
    this.y      = y;
    this.w      = w;
    this.h      = h;
    this.size   = size;
    this.speed  = speed;
    this.colors = colors;
    this.colIdx = 0;

    this.update = function(enemy) {
        this.size += this.speed;

        // judge bullet
        var delIdx = new Array();
        for (i = 0; i < enemy.bullets.length; i++) {
            if (touch(this.x, this.y, this.size,
                      enemy.bullets[i].x, enemy.bullets[i].y, enemy.bullets[i].size))
                delIdx.push(i);
        }
        enemy.delBullet(delIdx);

        // judge enemy
        if (touch(this.x, this.y, this.size, enemy.x, enemy.y, enemy.size) && enemy.life > 0)
            enemy.life--;
    };

    this.draw = function(ctx) {
        ctx.beginPath();
        ctx.fillStyle = this.colors[this.colIdx];
        ctx.arc(this.x, this.y, this.size, 0, Math.PI * 2.0, true);
        ctx.fill();
        ctx.closePath();

        if (++this.colIdx >= this.colors.length)
            this.colIdx = 0;
    };

    this.vanished = function() {
        if (this.size > this.w && this.size > this.h)
            return true;
        return false;
    };
};

var Trooper = function(name, actList, size, color, x, y, w, h,
                       life, speed, numBombs, barrages) {

    this.bullets  = new Array();
    this.bomb     = null;
    this.name     = name;
    this.actList  = actList;
    this.size     = size;
    this.color    = color;
    this.x        = x;
    this.y        = y;
    this.w        = w;
    this.h        = h;
    this.life     = life;
    this.speed    = speed;
    this.numBombs = numBombs;
    this.barrages = barrages;

    this.move = function(x, y) {
        this.x += x;
        this.y += y;
        this.adjustPosition();
    };

    this.moveAbs = function(x, y) {
        this.x = x;
        this.y = y;
        this.adjustPosition();
    };

    this.adjustPosition = function() {
        if (this.x > this.w)
            this.x = this.w;

        if (this.y > this.h)
            this.y = this.h;

        if (this.x < 0)
            this.x = 0;

        if (this.y < 0)
            this.y = 0;
    };

    this.isDead = function() {
        return this.life <= 0;
    };

    this.update = function(enemy) {
        var delIdx = null;

        // update my action
        this.actList.update(this, enemy);

        // update bomb
        if (this.bomb) {
            this.bomb.update(enemy);
            if (this.bomb.vanished())
                this.bomb = null;
        }

        // update/delete my bullets
        delIdx = new Array();
        for (i = 0; i < this.bullets.length; i++) {
            this.bullets[i].next();

            if (this.bullets[i].vanished())
                delIdx.push(i);
        }
        this.delBullet(delIdx);

        // judge/delete hit bullets
        delIdx = new Array();
        for (i = 0; i < enemy.bullets.length; i++) {
            if (touch(this.x, this.y, this.size,
                      enemy.bullets[i].x, enemy.bullets[i].y, enemy.bullets[i].size))
                delIdx.push(i);
        }
        enemy.delBullet(delIdx);

        // update life
        if (delIdx.length > 0 && this.life > 0)
            this.life--;
    };

    this.draw = function(ctx) {
        // draw bomb
        if (this.bomb)
            this.bomb.draw(ctx);

        // draw trooper
        ctx.beginPath();
        ctx.fillStyle = this.color;
        ctx.arc(this.x, this.y, this.size, 0, Math.PI * 2.0, true);
        ctx.fill();
        ctx.closePath();

        // draw bullets
        for (i = 0; i < this.bullets.length; i++)
            this.bullets[i].draw(ctx);
    };

    this.addBullet = function(bulletType, size, color, x, y, dir, speed) {
        this.bullets.push(
            new bulletType(size, color, this.x + x, this.y + y, dir, speed));
    };

    this.delBullet = function(idx) {
        if (idx.length <= 0)
            return;

        var newBullets = new Array();

        for (i = 0; i < idx.length; i++)
            this.bullets[idx[i]] = null;

        for (i = 0; i < this.bullets.length; i++)
            if (this.bullets[i])
                newBullets.push(this.bullets[i]);

        this.bullets = newBullets;
    };

    this.addBomb = function() {
        if (!this.bomb && this.numBombs > 0) {
            this.bomb = new Bomb(this.x, this.y, this.w, this.h, this.size * 2, 10,
                                 ["rgba(255,0,0,0.3)", "rgba(0,0,255,0.3)"]);
            this.numBombs--;
        }
    };
}
